-- Fluctuating Diesel Price
-- @author Premium AG
--

randomDieselPrice = {}

function randomDieselPrice:loadMap(mapFilename)
	if g_currentMission:getIsServer() then
		g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.hourChanged, self);
	end;
end;

function randomDieselPrice:deleteMap()
	if g_currentMission:getIsServer() then
		g_messageCenter:unsubscribe(MessageType.HOUR_CHANGED, self)
	end;
end;

function randomDieselPrice:changeDiesel()
	local economicDifficulty = g_currentMission.missionInfo.economicDifficulty
    local ftDiesel = g_fillTypeManager:getFillTypeByName("DIESEL")

    if ftDiesel == nil then
        print("[ERROR] randomDieselPrice: Not able to get Filltype by name 'DIESEL'")
        return
    end

	if economicDifficulty == 1 then
			ftDiesel.pricePerLiter = 1.0+(math.random()*0.5)
	elseif economicDifficulty == 2 then
			ftDiesel.pricePerLiter = 1.25+(math.random()*0.5)
	elseif economicDifficulty == 3 then
			ftDiesel.pricePerLiter = 1.5+(math.random()*0.5)
	end

end

function randomDieselPrice:hourChanged()
	local currentHour = g_currentMission.environment.currentHour

	if currentHour == 0 then
		self:changeDiesel();
	end;
	if currentHour == 6 then
		self:changeDiesel();
	end;
	if currentHour == 12 then
		self:changeDiesel();
	end;
	if currentHour == 18 then
		self:changeDiesel();
	end;
end;

addModEventListener(randomDieselPrice);

