--[[
    ExtendedVehicleConfigurationDataObjectChange

    This script extends the VehicleConfigurationDataObjectChange script by adding the ability to manually load object changes.

	@author: 		BayernGamers
	@date: 			19.03.2025
	@version:		1.0

	History:		v1.0 @19.03.2025 - initial implementation in FS 25
                    ------------------------------------------------------------------------------------------------------
	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage: 
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
ExtendedVehicleConfigurationDataObjectChange = {}

function ExtendedVehicleConfigurationDataObjectChange.registerXMLPaths(schema, rootPath, _)
    schema:register(XMLValueType.BOOL, rootPath .. "#isLoadedManually", "Defines if the object changes are updated manually", false)
end

function ExtendedVehicleConfigurationDataObjectChange.loadConfigItem(configItem, xmlFile, baseKey, configKey, baseDirectory, customEnvironment)
    configItem.isLoadedManually = xmlFile:getValue(baseKey .. "#isLoadedManually", false)
end

function ExtendedVehicleConfigurationDataObjectChange.manuallyLoadedObjectChange(func)
    return function(vehicle, configItem, configId)
        if not configItem.isLoadedManually then
            return func(vehicle, configItem, configId)
        end
    end
end

VehicleConfigurationDataObjectChange.registerXMLPaths = Utils.appendedFunction(VehicleConfigurationDataObjectChange.registerXMLPaths, ExtendedVehicleConfigurationDataObjectChange.registerXMLPaths)
VehicleConfigurationDataObjectChange.loadConfigItem = Utils.appendedFunction(VehicleConfigurationDataObjectChange.loadConfigItem, ExtendedVehicleConfigurationDataObjectChange.loadConfigItem)
VehicleConfigurationDataObjectChange.onLoad = ExtendedVehicleConfigurationDataObjectChange.manuallyLoadedObjectChange(VehicleConfigurationDataObjectChange.onLoad)
VehicleConfigurationDataObjectChange.onPostLoad = ExtendedVehicleConfigurationDataObjectChange.manuallyLoadedObjectChange(VehicleConfigurationDataObjectChange.onPostLoad)