-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: Farming Simulator 25
BaleTwineAddon = {SPEC_NAME = g_currentModName..".baleTwineAddon"} local modName = g_currentModName local modDirectory = g_currentModDirectory or "unknown" function BaleTwineAddon.initSpecialization() ConfigurationUtil.getConfigurationsFromXML = Utils.overwrittenFunction(ConfigurationUtil.getConfigurationsFromXML, getConfigurationsFromXML) end function BaleTwineAddon.prerequisitesPresent(specializations) return SpecializationUtil.hasSpecialization(Baler, specializations) end function BaleTwineAddon.registerEventListeners(vehicleType) SpecializationUtil.registerEventListener(vehicleType, "onLoad", BaleTwineAddon) SpecializationUtil.registerEventListener(vehicleType, "onChangedFillType", BaleTwineAddon) end function BaleTwineAddon:onLoad(savegame) if self.spec_baler ~= nil and not self.spec_baler.isRoundBaler then self.spec_baleTwineAddon = self["spec_"..BaleTwineAddon.SPEC_NAME] local spec = self.spec_baleTwineAddon spec.variationId = "none" spec.baleTwineFillUnit = 0 for i = 1, #self.spec_fillUnit.fillUnits do if self:getFillUnitAllowsFillType(i, FillType.BALE_TWINE) then spec.baleTwineFillUnit = i end end for _, configName in ipairs(Consumable.CONFIG_NAMES) do local configurationId = string.format("vehicle.consumable.%sConfigurations", configName) if self.xmlFile:hasProperty(configurationId) then local i = self.configurations[configName] or 1 local typeName = self.xmlFile:getValue(configurationId.."#typeName") if typeName ~= nil then if self.spec_consumable.typesByName[typeName] == nil then Logging.xmlWarning(self.xmlFile, "Consumable type name \'%s\' not found for configuration \'%s\'", typeName, configName) else self.spec_consumable.typesByName[typeName].defaultConsumableName = nil end end end end else SpecializationUtil.removeEventListener(self, "onChangedFillType", BaleTwineAddon) end end function BaleTwineAddon:onChangedFillType(fillUnitIndex, fillTypeIndex, oldFillTypeIndex) local spec = self.spec_baler if fillUnitIndex == spec.fillUnitIndex or fillUnitIndex == spec.buffer.fillUnitIndex then local mainFillTypeIndex = self:getFillUnitFillType(spec.fillUnitIndex) if mainFillTypeIndex == FillType.UNKNOWN then mainFillTypeIndex = fillTypeIndex end if mainFillTypeIndex ~= FillType.UNKNOWN then local baleTypeDef = spec.baleTypes[spec.currentBaleTypeIndex] spec.currentBaleTypeDefinition = baleTypeDef if not self.spec_baler.isRoundBaler then if self.spec_consumable.types[1].consumingVariationIndex ~= nil then self.spec_baleTwineAddon.variationId = string.sub(g_consumableManager:getConsumableVariationNameByIndex(self.spec_consumable.types[1].consumingVariationIndex), 32) end end spec.currentBaleXMLFilename, spec.currentBaleIndex = g_baleManager:getBaleXMLFilename(mainFillTypeIndex, baleTypeDef.isRoundBale, baleTypeDef.width, baleTypeDef.height, baleTypeDef.length, baleTypeDef.diameter, self.customEnvironment) local baleCapacity = g_baleManager:getBaleCapacityByBaleIndex(spec.currentBaleIndex, mainFillTypeIndex) if fillUnitIndex == spec.fillUnitIndex then self:setFillUnitCapacity(fillUnitIndex, baleCapacity, false) elseif spec.buffer.capacityPercentage ~= nil then self:setFillUnitCapacity(fillUnitIndex, baleCapacity * spec.buffer.capacityPercentage, false) end ObjectChangeUtil.setObjectChanges(baleTypeDef.changeObjects, true, self, self.setMovingToolDirty) if spec.currentBaleXMLFilename == nil then Logging.warning("Could not find bale for given bale type definition \'%s\'", baleTypeDef.index) end end end end function BaleTwineAddon:updateDebugValues(values) if not self.spec_baler.isRoundBaler then local spec = self.spec_baleTwineAddon table.insert(values, {name = "baleTwineFillUnit", value = string.format("base %.0f with color %s", spec.baleTwineFillUnit, spec.variationId)}) end end function getConfigurationsFromXML(manager, superfunc, xmlFile, key, baseDir, customEnvironment, isMod, storeItem) local configurations, defaultConfigurationIds = superfunc(manager, xmlFile, key, baseDir, customEnvironment, isMod, storeItem) if xmlFile:hasProperty("vehicle.baler") and xmlFile:hasProperty("vehicle.fillUnit") and not xmlFile:getValue("vehicle.baler.baleTypes.baleType(0)#isRoundBale", false) then if configurations["consumable"] ~= nil then for i = 1, #configurations["consumable"] do if configurations["consumable"][i].name ~= g_i18n:getText("configuration_valueEmpty") then configurations["consumable"][i].isSelectable = false end end end if configurations["consumable2"] ~= nil then for i = 1, #configurations["consumable2"] do if configurations["consumable2"][i].name ~= g_i18n:getText("configuration_valueEmpty") then configurations["consumable2"][i].isSelectable = false end end end end return configurations, defaultConfigurationIds end