local modName = g_currentModName

SteeringLock = {}
SteeringLock.SPEC_TABLE_NAME = "spec_"..modName..".steeringlock"

function SteeringLock.prerequisitesPresent(specializations)
    return true
end


function SteeringLock.registerEventListeners(vehicleType)
    -- we want the vehicle base class to call our "MileageCounter:onLoad" function during loading
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", SteeringLock)
end

function SteeringLock:onLoad(savegame)
   --local spec = self[SteeringBlock.SPEC_TABLE_NAME]
    self.steeringWheelBaseRotation = nil
    self.gpsChanged = false
    self.updateSteeringWheel = function(vehicle, steeringWheel, dt, direction)
        if steeringWheel ~= nil then
            local activeCamera = self.getActiveCamera and self:getActiveCamera()
            local isInside = activeCamera and activeCamera.isInside
            local isGPSactive = false
            local originalRotation = vehicle.rotatedTime * steeringWheel.outdoorRotation * direction

            if vehicle.getAIAutomaticSteeringState ~= nil then
                isGPSactive = vehicle:getAIAutomaticSteeringState() == AIAutomaticSteering.STATE.ACTIVE
            end

            if isGPSactive then

                self.gpsChanged = true

                self.steeringWheelBaseRotation = steeringWheel.lastRotation
                local rotation = steeringWheel.lastRotation or 0
                if isInside then
                    setRotation(steeringWheel.node, 0, rotation, 0)
                else
                    setRotation(steeringWheel.node, 0, 0, 0)
                end
            else
                local maxRotation = steeringWheel.indoorRotation or steeringWheel.outdoorRotation
                local rotation = vehicle.rotatedTime * maxRotation * direction
                if self.gpsChanged then
                    self.gpsChanged = false
                    self.steeringWheelBaseRotation = self.steeringWheelBaseRotation + (rotation *-1)
                end
                if isInside then
                    -- **Indoor camera**
                    if self.steeringWheelBaseRotation ~= nil then
                       rotation = self.steeringWheelBaseRotation + rotation
                    end
                    if steeringWheel.lastRotation ~= rotation then
                        steeringWheel.lastRotation = rotation
                        setRotation(steeringWheel.node, 0, rotation, 0)
                    end
                else
                    -- **Outdoor camera standart rotation**
                    if steeringWheel.lastRotation ~= originalRotation then
                        steeringWheel.lastRotation = originalRotation
                        setRotation(steeringWheel.node, 0, originalRotation, 0)
                    end
                end
            end
            if vehicle.getVehicleCharacter ~=nil then
                local vehicleCharacter = vehicle:getVehicleCharacter()
                if vehicleCharacter ~= nil then
                    if vehicleCharacter:getAllowCharacterUpdate() then
                        vehicleCharacter:setDirty(true)
                    end
                end
            end
        end
    end
end










